/*
 * Copyright (c) 2011, Collabora Ltd.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met);
 *
 *     * Redistributions of source code must retain the above
 *       copyright notice, this list of conditions and the
 *       following disclaimer.
 *     * Redistributions in binary form must reproduce the
 *       above copyright notice, this list of conditions and
 *       the following disclaimer in the documentation and/or
 *       other materials provided with the distribution.
 *     * The names of contributors to this software may not be
 *       used to endorse or promote products derived from this
 *       software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include "config.h"

#include <assert.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "p11-kit.h"

int
main (int argc, char *argv[])
{
	if (argc != 1) {
		fprintf (stderr, "usage: print-messages\n");
		exit (2);
	}

	#define X(x) printf ("%s: %s\n", #x, p11_kit_strerror (x))
	X(CKR_CANCEL);
	X(CKR_FUNCTION_CANCELED);
	X(CKR_HOST_MEMORY);
	X(CKR_SLOT_ID_INVALID);
	X(CKR_GENERAL_ERROR);
	X(CKR_FUNCTION_FAILED);
	X(CKR_ARGUMENTS_BAD);
	X(CKR_NEED_TO_CREATE_THREADS);
	X(CKR_CANT_LOCK);
	X(CKR_ATTRIBUTE_READ_ONLY);
	X(CKR_ATTRIBUTE_SENSITIVE);
	X(CKR_ATTRIBUTE_TYPE_INVALID);
	X(CKR_ATTRIBUTE_VALUE_INVALID);
	X(CKR_DATA_INVALID);
	X(CKR_DATA_LEN_RANGE);
	X(CKR_DEVICE_ERROR);
	X(CKR_DEVICE_MEMORY);
	X(CKR_DEVICE_REMOVED);
	X(CKR_ENCRYPTED_DATA_INVALID);
	X(CKR_ENCRYPTED_DATA_LEN_RANGE);
	X(CKR_FUNCTION_NOT_SUPPORTED);
	X(CKR_KEY_HANDLE_INVALID);
	X(CKR_KEY_SIZE_RANGE);
	X(CKR_KEY_TYPE_INCONSISTENT);
	X(CKR_KEY_NOT_NEEDED);
	X(CKR_KEY_CHANGED);
	X(CKR_KEY_NEEDED);
	X(CKR_KEY_INDIGESTIBLE);
	X(CKR_KEY_FUNCTION_NOT_PERMITTED);
	X(CKR_KEY_NOT_WRAPPABLE);
	X(CKR_KEY_UNEXTRACTABLE);
	X(CKR_MECHANISM_INVALID);
	X(CKR_MECHANISM_PARAM_INVALID);
	X(CKR_OBJECT_HANDLE_INVALID);
	X(CKR_OPERATION_ACTIVE);
	X(CKR_OPERATION_NOT_INITIALIZED);
	X(CKR_PIN_INCORRECT);
	X(CKR_PIN_INVALID);
	X(CKR_PIN_LEN_RANGE);
	X(CKR_PIN_EXPIRED);
	X(CKR_PIN_LOCKED);
	X(CKR_SESSION_CLOSED);
	X(CKR_SESSION_COUNT);
	X(CKR_SESSION_HANDLE_INVALID);
	X(CKR_SESSION_READ_ONLY);
	X(CKR_SESSION_EXISTS);
	X(CKR_SESSION_READ_ONLY_EXISTS);
	X(CKR_SESSION_READ_WRITE_SO_EXISTS);
	X(CKR_SIGNATURE_INVALID);
	X(CKR_SIGNATURE_LEN_RANGE);
	X(CKR_TEMPLATE_INCOMPLETE);
	X(CKR_TEMPLATE_INCONSISTENT);
	X(CKR_TOKEN_NOT_PRESENT);
	X(CKR_TOKEN_NOT_RECOGNIZED);
	X(CKR_TOKEN_WRITE_PROTECTED);
	X(CKR_UNWRAPPING_KEY_HANDLE_INVALID);
	X(CKR_UNWRAPPING_KEY_SIZE_RANGE);
	X(CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT);
	X(CKR_USER_ALREADY_LOGGED_IN);
	X(CKR_USER_NOT_LOGGED_IN);
	X(CKR_USER_PIN_NOT_INITIALIZED);
	X(CKR_USER_TYPE_INVALID);
	X(CKR_USER_ANOTHER_ALREADY_LOGGED_IN);
	X(CKR_USER_TOO_MANY_TYPES);
	X(CKR_WRAPPED_KEY_INVALID);
	X(CKR_WRAPPED_KEY_LEN_RANGE);
	X(CKR_WRAPPING_KEY_HANDLE_INVALID);
	X(CKR_WRAPPING_KEY_SIZE_RANGE);
	X(CKR_WRAPPING_KEY_TYPE_INCONSISTENT);
	X(CKR_RANDOM_SEED_NOT_SUPPORTED);
	X(CKR_RANDOM_NO_RNG);
	X(CKR_DOMAIN_PARAMS_INVALID);
	X(CKR_BUFFER_TOO_SMALL);
	X(CKR_SAVED_STATE_INVALID);
	X(CKR_INFORMATION_SENSITIVE);
	X(CKR_STATE_UNSAVEABLE);
	X(CKR_CRYPTOKI_NOT_INITIALIZED);
	X(CKR_CRYPTOKI_ALREADY_INITIALIZED);
	X(CKR_MUTEX_BAD);
	X(CKR_MUTEX_NOT_LOCKED);
	X(CKR_FUNCTION_REJECTED);
	#undef X

	return 0;
}
