*** Settings ***
Documentation       Check EMC DataDomain in SNMP

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Ctn Generic Suite Setup
Test Timeout        120s


*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=storage::emc::datadomain::snmp::plugin


*** Test Cases ***
replications ${tc}
    [Tags]    snmp  storage
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=replications
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=storage/emc/datadomain/snmp/slim-datadomain
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Regexp    ${command}    ${expected_result}

    Examples:        tc    extra_options                                                                       expected_result    --
            ...      1     --filter-counters='^status$'                                                        OK: All replications are ok
            ...      2     --filter-repl-index                                                                 OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
            ...      3     --filter-repl-source                                                                OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
            ...      4     --filter-repl-destination                                                           OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
            ...      5     --custom-perfdata-instances='%(type) %(source)%(destination)'                       OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
            ...      6     --unit='w'                                                                          OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.weeks'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.weeks'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.weeks'=\\\\d+[SsmhdwMyY];;;0;
            ...      7     --unknown-status='\\\%{state} ne "known"'                                           UNKNOWN: replication source 'Anonymized 127' destination 'Anonymized 057' \\\\[type: 1\\\\] state: normal, status: idle - replication source 'Anonymized 224' destination 'Anonymized 079' \\\\[type: 2\\\\] state: normal, status: idle - replication source 'Anonymized 016' destination 'Anonymized 146' \\\\[type: 3\\\\] state: normal, status: idle \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
            ...      8     --warning-status='\\\%{state} =~ /initializing|recovering/i'                        OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d*d;;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d*d;;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d*d;;;0;
            ...      9     --critical-status='\\\%{state} =~ /disabledNeedsResync|uninitialized/i'             OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
            ...      10    --warning-repl-detected --critical-repl-detected                                    OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; 
            ...      11    --warning-precompression-data-remaining --critical-precompression-data-remaining    OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
            ...      12    --warning-last-insync-time --critical-last-insync-time                              OK: All replications are ok \\\\| 'replications.detected.count'=3;;;0; '1~Anonymized 127~Anonymized 057#replication.precompression.data.remaining.bytes'=0;;;0; '1~Anonymized 127~Anonymized 057#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '2~Anonymized 224~Anonymized 079#replication.precompression.data.remaining.bytes'=0;;;0; '2~Anonymized 224~Anonymized 079#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0; '3~Anonymized 016~Anonymized 146#replication.precompression.data.remaining.bytes'=0;;;0; '3~Anonymized 016~Anonymized 146#replication.last.insync.days'=\\\\d+[SsmhdwMyY];;;0;
