# CHANGES IN Eureka 2.1.0

(Since version 2.0.2)

## Editing features

* Added MBF21 support.
* The thing spawn flags are now defined in UGH files.
* The linedef flags are also defined in UGH files.
* The generalized sector specials are also defined in UGH files.
* The quirky two-sided linedef flag is now editable.
* Made the pass-through activation types editable in Hexen format.
* Corrected some advanced source port thing flag definitions.

## Editing improvements

* When dragging geometry more complex than single vertices, no longer pull from the nearby linedefs
  to split them if not touching directly. Only do it if they touch the line directly, or when drag-
  ging a single vertex.

## User interface

* Added tag trigger indicators on the 2D view. Thanks to selliott512 for the contribution!
* BEHAVIOR, ACS source and SMMU map header lump edits can now be undone.
* Now Redo has both Ctrl+Y and Ctrl+Shift+Z bindings (Cmd on macOS).
* Preferences dialog now allows binding multiple modifier keys (i.e. CMD-ALT-...) per action.
* Now all menu shortcut keys are customizable in Preferences.
* Improved the view of the key bindings in the Preferences dialog. Added undo/redo buttons.
* Now the document dirty status updates correctly when undoing to the same state as last saved.
* Now on macOS, the key bindings in the Preferences dialog show with the specific symbols.
* Corrected high DPI display to actually use the full resolution in the map view.
* Fixed the wrong user manual link from the Help menu.
* Thing spawn flags (options) can now be changed directly by the number, not just by check boxes.
* Things in the browser can now be searched by name or doomednum even when in pic mode.
* macOS: partially implemented the file icon on the title bar. It can be drag-dropped, but currently
  cannot be right-clicked.
* macOS: now the window exit button gets marked when document is dirty.

## Bug fixes

* Further fixed the multiple dragging bug as it wasn't properly fixed before.
* Fixed wrong flat rendering for sizes not 64x64.
* Fixed failure on Windows to save unicode paths from the text lumps and log viewer.
* Fixed failed editing of one-sided linedef textures when selecting the texture in the sidedef panel.
* Fixed empty BEHAVIOR lump being saved for new levels, crashing Hexen.
* Fixed unexpected void columns being made when drawing a sector tethered to a vertex of the surrounding room.

## Organizing

* Now on Linux the user settings and cache are stored XDG compliant (in `~/.config/eureka` and
  `~/.cache/eureka`), instead of haphazardly in `~/.eureka`. Existing settings from the old folder
  will be transferred to the new places.

## Backend

* Updated FLTK to version 1.4.4. Fixes include:
  - crash in macOS when switching full screen Eureka between displays, particularly if one of them
    has scaled pixels
  - locking up in macOS when reading an invalid JPEG file
* Fixed some Debian building and segfault problems -- thanks to jordibc for the fix!

## Documentation

* Added contributors to AUTHORS.md

## Development

* FLTK is now loaded using CMake `FetchContent` instead of being built in a raw fashion using a
  custom command.
* Added CMake options to use system FLTK and/or Google Test, as opposed to fetching them from
  GitHub. This will help fix issues for systems where internet access is blocked.
