#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import os

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import mark_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("imports text from clipboard file to the clipboard")

    def run(self):
        clipboard_file_path = self.env["runtime"][
            "SettingsManager"
        ].get_setting("general", "clipboardExportPath")
        clipboard_file_path = clipboard_file_path.replace(
            "$user", self.env["general"]["curr_user"]
        )
        clipboard_file_path = clipboard_file_path.replace(
            "$USER", self.env["general"]["curr_user"]
        )
        clipboard_file_path = clipboard_file_path.replace(
            "$User", self.env["general"]["curr_user"]
        )
        if not os.path.exists(clipboard_file_path):
            self.env["runtime"]["OutputManager"].present_text(
                _("File does not exist"), sound_icon="", interrupt=True
            )
            return
        clipboard_file = open(clipboard_file_path, "r")
        imported = clipboard_file.read()
        clipboard_file.close()
        self.env["runtime"]["MemoryManager"].add_value_to_first_index(
            "clipboardHistory", imported
        )

        self.env["runtime"]["OutputManager"].present_text(
            "Import to Clipboard", sound_icon="CopyToClipboard", interrupt=True
        )
        self.env["runtime"]["OutputManager"].present_text(
            imported, sound_icon="", interrupt=False
        )

    def set_callback(self, callback):
        pass
