#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import char_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _(
            "Move review to the character in the line above the current position"
        )

    def run(self):
        cursor_pos = self.env["runtime"][
            "CursorManager"
        ].get_review_or_text_cursor()
        (
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            upChar,
            end_of_screen,
        ) = char_utils.get_up_char(
            self.env["screen"]["newCursorReview"]["x"],
            self.env["screen"]["newCursorReview"]["y"],
            self.env["screen"]["new_content_text"],
        )
        line_break = False
        self.env["runtime"]["OutputManager"].present_text(
            upChar,
            interrupt=True,
            ignore_punctuation=True,
            announce_capital=True,
            flush=False,
        )
        if end_of_screen:
            if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                "review", "end_of_screen"
            ):
                self.env["runtime"]["OutputManager"].present_text(
                    _("end of screen"),
                    interrupt=True,
                    sound_icon="EndOfScreen",
                )
        if line_break:
            if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                "review", "line_break"
            ):
                self.env["runtime"]["OutputManager"].present_text(
                    _("line break"), interrupt=False, sound_icon="EndOfLine"
                )

    def set_callback(self, callback):
        pass
