#!/usr/bin/env python3

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "Adjust speech volume (loudness)"

    def run(self):
        try:
            # Get current volume
            current_volume = float(
                self.env["runtime"]["SettingsManager"].get_setting(
                    "speech", "volume"
                )
            )
        except Exception as e:
            current_volume = 1.0

        # Present current volume
        volume_percent = int(current_volume * 100)
        self.env["runtime"]["OutputManager"].present_text(
            f"Current speech volume: {volume_percent} percent", interrupt=True
        )

        # Increase by 10%, wrap around if at max
        new_volume = current_volume + 0.1
        if new_volume > 1.0:
            new_volume = 0.1  # Wrap to minimum

        # Apply the new volume
        self.env["runtime"]["SettingsManager"].set_setting(
            "speech", "volume", str(new_volume)
        )

        new_percent = int(new_volume * 100)
        self.env["runtime"]["OutputManager"].present_text(
            f"Speech volume set to {new_percent} percent", interrupt=True
        )
        self.env["runtime"]["OutputManager"].play_sound("Accept")

    def set_callback(self, callback):
        pass
