# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.applicationinsights import ApplicationInsightsManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-applicationinsights
# USAGE
    python favorite_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ApplicationInsightsManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.favorites.update(
        resource_group_name="my-resource-group",
        resource_name="my-ai-component",
        favorite_id="deadb33f-5e0d-4064-8ebb-1a4ed0313eb2",
        favorite_properties={
            "Category": None,
            "Config": '{"MEDataModelRawJSON":"{\\"version\\": \\"1.4.1\\",\\"isCustomDataModel\\": true,\\"items\\": [{\\"id\\": \\"90a7134d-9a38-4c25-88d3-a495209873eb\\",\\"chartType\\": \\"Area\\",\\"chartHeight\\": 4,\\"metrics\\": [{\\"id\\": \\"preview/requests/count\\",\\"metricAggregation\\": \\"Sum\\",\\"color\\": \\"msportalfx-bgcolor-d0\\"}],\\"priorPeriod\\": false,\\"clickAction\\": {\\"defaultBlade\\": \\"SearchBlade\\"},\\"horizontalBars\\": true,\\"showOther\\": true,\\"aggregation\\": \\"Sum\\",\\"percentage\\": false,\\"palette\\": \\"fail\\",\\"yAxisOption\\": 0,\\"title\\": \\"\\"},{\\"id\\": \\"0c289098-88e8-4010-b212-546815cddf70\\",\\"chartType\\": \\"Area\\",\\"chartHeight\\": 2,\\"metrics\\": [{\\"id\\": \\"preview/requests/duration\\",\\"metricAggregation\\": \\"Avg\\",\\"color\\": \\"msportalfx-bgcolor-j1\\"}],\\"priorPeriod\\": false,\\"clickAction\\": {\\"defaultBlade\\": \\"SearchBlade\\"},\\"horizontalBars\\": true,\\"showOther\\": true,\\"aggregation\\": \\"Avg\\",\\"percentage\\": false,\\"palette\\": \\"greenHues\\",\\"yAxisOption\\": 0,\\"title\\": \\"\\"},{\\"id\\": \\"cbdaab6f-a808-4f71-aca5-b3976cbb7345\\",\\"chartType\\": \\"Bar\\",\\"chartHeight\\": 4,\\"metrics\\": [{\\"id\\": \\"preview/requests/duration\\",\\"metricAggregation\\": \\"Avg\\",\\"color\\": \\"msportalfx-bgcolor-d0\\"}],\\"priorPeriod\\": false,\\"clickAction\\": {\\"defaultBlade\\": \\"SearchBlade\\"},\\"horizontalBars\\": true,\\"showOther\\": true,\\"aggregation\\": \\"Avg\\",\\"percentage\\": false,\\"palette\\": \\"magentaHues\\",\\"yAxisOption\\": 0,\\"title\\": \\"\\"},{\\"id\\": \\"1d5a6a3a-9fa1-4099-9cf9-05eff72d1b02\\",\\"grouping\\": {\\"kind\\": \\"ByDimension\\",\\"dimension\\": \\"context.application.version\\"},\\"chartType\\": \\"Grid\\",\\"chartHeight\\": 1,\\"metrics\\": [{\\"id\\": \\"basicException.count\\",\\"metricAggregation\\": \\"Sum\\",\\"color\\": \\"msportalfx-bgcolor-g0\\"},{\\"id\\": \\"requestFailed.count\\",\\"metricAggregation\\": \\"Sum\\",\\"color\\": \\"msportalfx-bgcolor-f0s2\\"}],\\"priorPeriod\\": true,\\"clickAction\\": {\\"defaultBlade\\": \\"SearchBlade\\"},\\"horizontalBars\\": true,\\"showOther\\": true,\\"percentage\\": false,\\"palette\\": \\"blueHues\\",\\"yAxisOption\\": 0,\\"title\\": \\"\\"}],\\"currentFilter\\": {\\"eventTypes\\": [1,2],\\"typeFacets\\": {},\\"isPermissive\\": false},\\"timeContext\\": {\\"durationMs\\": 75600000,\\"endTime\\": \\"2018-01-31T20:30:00.000Z\\",\\"createdTime\\": \\"2018-01-31T23:54:26.280Z\\",\\"isInitialTime\\": false,\\"grain\\": 1,\\"useDashboardTimeRange\\": false},\\"jsonUri\\": \\"Favorite_BlankChart\\",\\"timeSource\\": 0}"}',
            "FavoriteId": "deadb33f-5e0d-4064-8ebb-1a4ed0313eb2",
            "FavoriteType": "shared",
            "IsGeneratedFromTemplate": False,
            "Name": "Derek Changed This",
            "SourceType": None,
            "Tags": ["TagSample01", "TagSample02", "TagSample03"],
            "TimeModified": "2018-02-02T18:39:11.6569686Z",
            "Version": "ME",
        },
    )
    print(response)


# x-ms-original-file: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2015-05-01/examples/FavoriteUpdate.json
if __name__ == "__main__":
    main()
