// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{ffi, FileChooser, FileChooserAction, FileFilter, NativeDialog, Window};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkFileChooserNative")]
    pub struct FileChooserNative(Object<ffi::GtkFileChooserNative, ffi::GtkFileChooserNativeClass>) @extends NativeDialog, @implements FileChooser;

    match fn {
        type_ => || ffi::gtk_file_chooser_native_get_type(),
    }
}

impl FileChooserNative {
    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_file_chooser_native_new")]
    pub fn new(
        title: Option<&str>,
        parent: Option<&impl IsA<Window>>,
        action: FileChooserAction,
        accept_label: Option<&str>,
        cancel_label: Option<&str>,
    ) -> FileChooserNative {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_file_chooser_native_new(
                title.to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
                action.into_glib(),
                accept_label.to_glib_none().0,
                cancel_label.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`FileChooserNative`] objects.
    ///
    /// This method returns an instance of [`FileChooserNativeBuilder`](crate::builders::FileChooserNativeBuilder) which can be used to create [`FileChooserNative`] objects.
    pub fn builder() -> FileChooserNativeBuilder {
        FileChooserNativeBuilder::new()
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_file_chooser_native_get_accept_label")]
    #[doc(alias = "get_accept_label")]
    #[doc(alias = "accept-label")]
    pub fn accept_label(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_file_chooser_native_get_accept_label(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_file_chooser_native_get_cancel_label")]
    #[doc(alias = "get_cancel_label")]
    #[doc(alias = "cancel-label")]
    pub fn cancel_label(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_file_chooser_native_get_cancel_label(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_file_chooser_native_set_accept_label")]
    #[doc(alias = "accept-label")]
    pub fn set_accept_label(&self, accept_label: Option<&str>) {
        unsafe {
            ffi::gtk_file_chooser_native_set_accept_label(
                self.to_glib_none().0,
                accept_label.to_glib_none().0,
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_file_chooser_native_set_cancel_label")]
    #[doc(alias = "cancel-label")]
    pub fn set_cancel_label(&self, cancel_label: Option<&str>) {
        unsafe {
            ffi::gtk_file_chooser_native_set_cancel_label(
                self.to_glib_none().0,
                cancel_label.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "accept-label")]
    pub fn connect_accept_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_label_trampoline<F: Fn(&FileChooserNative) + 'static>(
            this: *mut ffi::GtkFileChooserNative,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::accept-label".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_accept_label_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cancel-label")]
    pub fn connect_cancel_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cancel_label_trampoline<F: Fn(&FileChooserNative) + 'static>(
            this: *mut ffi::GtkFileChooserNative,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::cancel-label".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_cancel_label_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for FileChooserNative {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`FileChooserNative`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FileChooserNativeBuilder {
    builder: glib::object::ObjectBuilder<'static, FileChooserNative>,
}

impl FileChooserNativeBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accept_label(self, accept_label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("accept-label", accept_label.into()),
        }
    }

    pub fn cancel_label(self, cancel_label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("cancel-label", cancel_label.into()),
        }
    }

    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn transient_for(self, transient_for: &impl IsA<Window>) -> Self {
        Self {
            builder: self
                .builder
                .property("transient-for", transient_for.clone().upcast()),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    pub fn action(self, action: FileChooserAction) -> Self {
        Self {
            builder: self.builder.property("action", action),
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    pub fn create_folders(self, create_folders: bool) -> Self {
        Self {
            builder: self.builder.property("create-folders", create_folders),
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    pub fn filter(self, filter: &FileFilter) -> Self {
        Self {
            builder: self.builder.property("filter", filter.clone()),
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    pub fn select_multiple(self, select_multiple: bool) -> Self {
        Self {
            builder: self.builder.property("select-multiple", select_multiple),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`FileChooserNative`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> FileChooserNative {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
