package ONVIF::Analytics::Types::ColorspaceRange;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %X_of :ATTR(:get<X>);
my %Y_of :ATTR(:get<Y>);
my %Z_of :ATTR(:get<Z>);
my %Colorspace_of :ATTR(:get<Colorspace>);

__PACKAGE__->_factory(
    [ qw(        X
        Y
        Z
        Colorspace

    ) ],
    {
        'X' => \%X_of,
        'Y' => \%Y_of,
        'Z' => \%Z_of,
        'Colorspace' => \%Colorspace_of,
    },
    {
        'X' => 'ONVIF::Analytics::Types::FloatRange',
        'Y' => 'ONVIF::Analytics::Types::FloatRange',
        'Z' => 'ONVIF::Analytics::Types::FloatRange',
        'Colorspace' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
    },
    {

        'X' => 'X',
        'Y' => 'Y',
        'Z' => 'Z',
        'Colorspace' => 'Colorspace',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::ColorspaceRange

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ColorspaceRange from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * X


=item * Y


=item * Z


=item * Colorspace




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::ColorspaceRange
   X =>  { # ONVIF::Analytics::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
   Y =>  { # ONVIF::Analytics::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
   Z =>  { # ONVIF::Analytics::Types::FloatRange
     Min =>  $some_value, # float
     Max =>  $some_value, # float
   },
   Colorspace =>  $some_value, # anyURI
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

